/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.fluid;

import cofh.core.network.PacketBase;
import cofh.core.util.helpers.BlockHelper;
import cofh.thermaldynamics.duct.fluid.DuctUnitFluid;
import cofh.thermaldynamics.duct.fluid.GridFluid;
import cofh.thermaldynamics.duct.tiles.DuctToken;
import cofh.thermaldynamics.duct.tiles.IDuctHolder;
import com.google.common.collect.Iterables;
import java.io.ByteArrayInputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class PacketFluid
extends PacketBase {
    public ByteArrayInputStream stream;

    public PacketFluid() {
    }

    public PacketFluid(GridFluid grid, int size) {
        this.addFluidStack(grid.getRenderFluid());
        this.addVarInt(size);
        for (Object block : Iterables.concat((Iterable)grid.nodeSet, (Iterable)grid.idleSet)) {
            DuctUnitFluid duct = (DuctUnitFluid)block;
            if (duct.getDuctType().opaque) continue;
            this.addVarInt(duct.x());
            this.addVarInt(duct.y());
            this.addVarInt(duct.z());
        }
    }

    public void handlePacket(EntityPlayer player, boolean isServer) {
        FluidStack fluid = this.getFluidStack();
        int n = this.getVarInt();
        World world = player.field_70170_p;
        for (int i = 0; i < n; ++i) {
            DuctUnitFluid duct;
            TileEntity tile;
            int z;
            int y;
            int x = this.getVarInt();
            BlockPos pos = new BlockPos(x, y = this.getVarInt(), z = this.getVarInt());
            if (!world.func_175667_e(pos) || !((tile = world.func_175625_s(pos)) instanceof IDuctHolder) || (duct = ((IDuctHolder)tile).getDuct(DuctToken.FLUID)) == null) continue;
            duct.myRenderFluid = fluid;
            duct.updateLighting();
            BlockHelper.callBlockUpdate((World)world, (BlockPos)new BlockPos(x, y, z));
        }
    }
}

